﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using AZVIC.Ei8htPOS.Utilities;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;

namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for MiscItems.xaml
    /// </summary>
    public partial class MiscItems : Window
    {
        public MiscItems()
        {
            InitializeComponent();
            txtProductName.Focus();
        }

        private void btnAddProduct_Click(object sender, RoutedEventArgs e)
        {
            if (ValidateValues())
            {
                Products openItem = AppSession.ProductsList.Where(p => p.IsMiscellaneous == true).FirstOrDefault();

                openItem.IsMiscellaneous = true;
                openItem.ProductName = txtProductName.Text.Trim();
                openItem.ProductDescriptions = txtProductDescription.Text.Trim();
                openItem.UnitPrice = decimal.Parse(txtPrice.Text.Trim());

                AppSession.AddProductToCart(AppSession.CurrentOrders, openItem, openItem.UnitPrice, string.Empty, 0, int.Parse(txtQuantity.Text.Trim()), 0, string.Empty, true, true,0);

                this.Tag = true;
                this.Close();
            }
        }

        private bool ValidateValues()
        {
            if (!ValidationUtility.ValidateString(txtProductName.Text.Trim()))
            {
                MessageBox.Show("Please enter Product Name", "Ei8ht POS", MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
                txtProductName.Focus();
                return false;
            }

            if (!ValidationUtility.ValidateDecimal(txtPrice.Text.Trim()))
            {
                MessageBox.Show("Please enter Valid Product Price", "Ei8ht POS", MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
                txtPrice.Focus();
                return false;
            }

            if (!ValidationUtility.ValidateInt(txtQuantity.Text.Trim()))
            {
                MessageBox.Show("Please enter Valid Quantity", "Ei8ht POS", MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
                txtQuantity.Focus();
                return false;
            }

            return true;
        }

        private void btnCancel_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }
    }
}
